#!perl

# This program will start by reading in data from the file
# country_dumpCountryExists.txt in the output directory defined in
# daemon_config.inc (or alternative configuration file). For any
# countries that don't have a Yes value anywhere, every country_*.txt
# file will be edited by removing those columns. It tends to cut the
# number of columns to about 50%, which make it more manageable.

#---------------------------------------------------------------------
# Copyright (C) 2003 Chad Redman <chad_eu2@katica.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#---------------------------------------------------------------------

# Revision: $Id: clean_unused_countries.pl,v 1.1.1.1 2003/02/12 03:15:23 chad Exp $


require ".\\daemon_config.inc" or die "$!\n";

foreach (@ARGV) {
    require ".\\daemon_config_$_.inc" or die "Failed to read 'daemon_config_$_.inc' -- $!\n";
}


unless (open IN, "< $outputdir/country_dumpCountryExists.txt") {
    die "Could not open $outputdir/country_dumpCountryExists.txt\n  $!\n";
}


my @counts = ();
$_ = <IN>;  #read first line
chomp;
my @countries = split "\t", $_;

while (<IN>) {
    chomp;
    my $i = 0;
    foreach my $cell (split "\t", $_) {
        $counts[$i++] += ( $cell eq 'Yes' ? 1 : 0 );
    }
}

my @remove_cols;
my @keep_cols;

foreach my $i ( 2 .. $#countries ) {
    if ($counts[$i] == 0) {
        push @remove_cols, $i;
    } else {
        push @keep_cols, $i;
    }
}


print join("\t", @keep_cols),"\n";
print join("\t", @remove_cols),"\n";

print join("\t", @countries[@keep_cols]),"\n";
print join("\t", @countries[@remove_cols]),"\n";


print "Will keep: ", join(" ", @countries[@keep_cols]), "\n\n";

print "Remove the following columns? ", join(" ", @countries[@remove_cols]), "\n\n";

my $ans = '?';
while ($ans ne 'N' and $ans ne 'Y') {
    print "Y/N? ";
    $ans = uc(getc);
    chomp $ans;
}

exit 0 if $ans eq 'N';

chdir $outputdir or die "$!\n";


$/ = undef;  #suck in whole files
foreach my $file ( <country_*.txt> ) {
    if (!open(IN, "< $file")) {
        warn "Could not open file $file: $!\n";
        next;
    }

    my $data = <IN>;
    close IN;

    open (IN, "> $file");
    foreach my $line (split "\n", $data) {
        print IN join("\t", (split "\t", $line)[0, 1, @keep_cols]), "\n";
    }

   close IN;
}

exit 0;
