#!perl

#---------------------------------------------------------------------
# Copyright (C) 2003 Chad Redman <chad_eu2@katica.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#---------------------------------------------------------------------

# Revision: $Id: daemon.pl,v 1.3 2003/02/12 03:38:14 chad Exp $

use lib '.';
use Cwd 'abs_path';
use Savefile;


### Process command line arguments
use Getopt::Long;
GetOptions('now', 'help') or exit &Syntax();
if ($opt_help==1) {
    exit &Syntax;
}

require ".\\daemon_config.inc" or die "$!\n";

foreach (@ARGV) {
    require ".\\daemon_config_$_.inc" or die "Failed to read 'daemon_config_$_.inc' -- $!\n";
}


Savefile::LogLevel ($loglevel);
Savefile::EU2Tree (@eu2trees);
Savefile::OutputDir ($outputdir);           ## TODO: Check whether this is empty before creating new files

Savefile::log 0, "\n" . '='x42 . "\n$0 started " . scalar(localtime) . "\n" . '='x42;

Savefile::log 1, "Settings:\n"
    . "    Savefile = \"$savefile\"\n"
    . "    EU2 Base Tree(s) = [\"" . join("\",\n        \"", @eu2trees) . "\"]\n"
    . "    Output directory = \"" . &abs_path($outputdir) . "\"\n"
    . "    read_wait = $read_wait\n"
    . "    loop_wait = $loop_wait\n"
    . "    loglevel = $loglevel\n";

Savefile::initDbData;
Savefile::logGlobal (@log_global);
Savefile::logCountry (@log_country);


### This writes formatted data from Db/country.csv to $outputdir/db_countries.txt
Savefile::dumpDbData('countries', 'name',
                                  'tech_group',
                                  'policystring',      #strung together: arist/cent/innov/merc/offens/land/qual/serf
                                  'electors');


### This writes formatted data from Db/province.csv to $outputdir/db_provinces.txt
Savefile::dumpDbData('provinces', 'name',
                                    'religion',
                                    'culture',
                                    'manpower',
                                    'income',
                                    'terrain',
                                    'mine',
                                    'goods',
                                    'natives',
                                    'area',
                                    'region',
                                    'continent');





my ($szOld, $timeOld, $gmdtOld);

$gmdtOld = '0';
if ($opt_now) {
        ($szOld, $timeOld) = (0, 0);   ## will cause an immediate savefile parse upon first test
} else {
        ($szOld, $timeOld) = (stat $savefile)[7, 9];
}


Savefile::dumpHeader;

while (1) {
    my ($szNew, $timeNew) = (stat $savefile)[7, 9];
    sleep $loop_wait and next unless ($timeOld != (stat $savefile)[7] and $szOld != (stat $savefile)[7]);

    while ( $timeOld != ($timeNew = (stat $savefile)[9]) ) {
        ## Just going by the time difference, occassionally it determines that the savefile
        ## is new, when really it just hasn't finished writing yet. Sometimes, this causes
        ## parsing errors, and sometimes it reads the same savefile twice (depending on whether
        ## the eyr section has been written yet). To minimize this, we will keep looping until
        ## the timestamp has stabilized
        Savefile::log 4, "DEBUG: timestamp stabilize loop: old/new = $timeOld / $timeNew";
        $timeOld = $timeNew;
        sleep $read_wait;
        next;
    }

    ($szOld, $timeOld) = ($szNew, $timeNew);

    my $savedata = new Savefile($savefile);

    Savefile::log 1, scalar(localtime) . " \tParse started";
    if ($savedata->parse()) {
        if ($savedata->getGameDate ne $gmdtOld) {
            $savedata->dumpData;
            Savefile::log 1, scalar(localtime) . " \tOutput complete. Game date was " . $savedata->getGameDate;
            $gmdtOld = $savedata->getGameDate;
        } else {
            Savefile::log 3, "Data not saved because game date did not change (Game date was " . $savedata->getGameDate . ")";
        }
    } else {
        Savefile::log 1, scalar(localtime) . " \tFailed to parse data";
    }

    $savedata = undef;
}

exit 0;

#---------------------


sub Syntax {
    print STDERR <<EOF;
Syntax: $0 [-now] [config_tag(s)...]

    -now : Process the savefile as soon as the program starts. Don't
           wait for the first change in the timestamp to start reading.
    config_tag: Will read any variable definitions found in the file
           daemon_config_(config_tag).inc, overriding any existing
           definitions. When multiple tags are specified, each will
           be executed in sequence.
EOF
    0;
};
