# Revision: $Id: daemon_config.inc,v 1.2 2003/02/12 03:41:28 chad Exp $

# This file is used to configure values specific to this machine. When
# executing the main perl script, adding the name of this file to the
# command line will cause the program to read the desired settings.
# thus, multiple settings may be kept for running under different
# conditions. For example, an AGC or EEP games would need specific
# settings for the EU2 directory trees to search for it's own game data,
# which would be different from a standard game. If no command line flag
# is given, the default file to use is "daemon_config.inc" in the current
# directory.


use vars ('$read_wait', '$loop_wait', '$savefile', '$outputdir', '@eu2trees',
           '@log_global', '@log_country', '$loglevel');


### The savefile is the full path to the saved game data. The values
### should always be in single quotes (or double quotes if you
### use \\ instead of \ for paths)

$savefile = 'C:\Program Files\Strategy First\Europa Universalis 2\Scenarios\Save Games\autosave.eug';


### The outputdir value is the directory where output files should go. The
### directory will be created if it doesn't exist.

$outputdir = './output';                # either forward or back slashes will work

### eu2trees specifies the root directory(s) where the program can find
### default province, country, and other data. At the least, there needs
### to be one entry, the location of EU2 itself, which will contain the
### subdirectories Config and Db. For custom games like AGC or EEP,
### specify the moddir location as a higher entry in the list. The program
### will first attempt to locate files based on the first specified
### location, and will keep trying successive entries in the list until
### the desired file is found

@eu2trees = (
    #'C:\Program Files\Strategy First\Europa Universalis 2\AGC',   ## uncomment this line for an AGC game
    #'C:\Program Files\Strategy First\Europa Universalis 2\EEP',   ## uncomment this line for an EEP game
    'C:\Program Files\Strategy First\Europa Universalis 2',       ## The last resort for game data files
    );


### Types of data that are specific to the savefile as a whole. These
### will get logged to the file 'globals.txt'. Uncomment the ones you
### want to track

@log_global = (
   #'filename',               ## the full directory and name of the savefile
    'size',                   ## number of bytes in the file
    'timestamp',              ## The time the savefile was saved, given as the number of elapsed
                              #      seconds since 1/1/1970. Can be used to measure how fast the game is going
    'dumpTimestampFormat',    ## The time the savefile was saved, given as yyyy/mm/dd hh:mm:ss
    'startdate',              ## the game date. For autosaves, the date 01/00 (Jan. 0) will be converted to 01/01
    'dumpStartYear',          ## the year portion of the game date. This sometimes works better
                              #       in spreadsheets than the full date
   #'gametype',               ## not sure. Does '0' mean a single player game?
   #'saved',                  ## don't know. I've only seen a value of 'yes'
   #'free',                   ## don't know. I've only seen a value of 'yes'
   #'optionmode',             ## don't know. I've only seen a value of '0'
   #'set_ai_aggresive',       ## AI agression. I think '2' is normal
   #'set_difficulty',         ## game difficulty. I think '2' is normal
   #'set_gamespeed',          ## game speed. I think '6' is 1 year/minute
   #'set_fow',                ## '1' means fog of war option is on
   #'set_conq_capital',       ## '1' means forced annexation option is on
   #'set_missions',           ## flag whether dynamic missions option is on
   #'set_basevp',             ## Flag whether using victory points
    'dumpPlayers',            ## A comma separated list of TAG="name" values for player nations
    'emperor',                ## The tag for the current HRE
    'dumpEventFlags',              ## Tortesillas, Reformation, Calvin, Council of Trent, Edict of Tolerance,
                                   #      French Tricolor, English Union Jack
    'dumpDiscoveredRegions',       ## yes/no flags for whether special regions the game tracks have been discovered
    'dumpEstablishedRegions',      ## yes/no flags for special goals (TP in Japan, colony in America, etc.)
    'dumpTotalNativePop',          ## the sum total of all natives in all provinces
    'dumpNativePopPerContinent',   ## the total natives in all provinces, broken down by continent
    'dumpTotalMerchantIncome',     ## the total trade income for all countries in all CoT's
    'dumpTotalMerchants',          ## the total trade income for all countries in all CoT's
    'dumpNumCoTs',                 ## the total number of CoT's
    );


### Types of data that can be broken down by country. These will list the
### game date in column 1, the game year in column 2 (the same date, but
### usable as an X-axis in graphs), and 1 row for each country,
### alphabetically. Every country will be included, even pirates, rebels,
### natives and mercenaries. Each data type will be saved to a different
### file, named 'country_<type>.txt'.

@log_country = (
    'badboy',
    'religion',
    'whiteman',
    'vp',
    'treasury',
    'income',
    'inflation',
    'manpower',
    'navalpercentage',
    'landpercentage',
    'tepercentage',
    'pepercentage',
    'stabilitypercentage',
    'treasurypercentage',
    'tax',
   #'num_known_provs',        ## this is the same value as countKnownProvinces
    'num_warships',
    'num_galleys',
    'num_transports',
    'num_inf',
    'num_cav',
    'num_art',
    'tech_group',
    'electors',
    'dumpNumCotOwned',       ## Number of CoT's owned by the country
    'dumpNumCotMonopoly',    ## Number of CoT's in which the country has a monopoly
    'dumpNumCotPresence',    ## Number of CoT's in which the country has a presence
    'dumpMerchantIncome',    ## Total income from merchants in CoT's
    'dumpNumMerchants',      ## Total number of merchants
    'dumpCountryExists',     ## Gives 'yes' if the country currently exists in the game, or blank if not
    'dumpPlayerName',        ## Only useful for person-played countries. Gives the user name or blank
    'countOwnedProvinces',   ## Number if provinces owned by each country
    'countKnownProvinces',   ## Number of territories known, both land and water
    'DiploString',           ## DP Settings, in the order: aristocracy-centralization-innovative-mercantilism-offensive-land-quality-serfdom
    'totalArmy',             ## The sum of (num_inf, num_cav, num_art)
    'totalNavy',             ## The sum of (num_warships, num_galleys, num_transports)
	);


### The read_wait value set the number of seconds the program should wait
### between detecting a change in savefile modification time and acting on
### it. This gives the game time to finish writing the file to disk, so
### that a half-written file is not being read.

$read_wait = 3;


### The loop_wait value is the interval in seconds between checking for a
### change in the savefile. It should be something greater than 0, so that
### the program doesn't steal too much processor time.

$loop_wait = 9;


### loglevel determines what gets logged to $outputdir/daemon_log.txt. The levels are:
#     0: Don't log anything
#     1: Basic information: parameters used, time of parse start and completion, gamedate in savefile
#     2: Above, plus: output files used
#     3: Above, plus: time/size of savefile when change detected, number of tokens parsed
#     4: Low-level, debugging stuff

$loglevel = 3;

#----------------------------

1;    # Needed by perl
